/***************************************************************************/
/*                                                                         */
/*  fs_port.h - port file that includes the platform specific iType port   */
/*              file then redefines a set of file io routines so that      */
/*              FT_Stream support is available in iType-Connects.          */
/*              Include paths are set in project/makefiles such that this  */
/*              file is found first.                                       */
/*                                                                         */
/*  Copyright (C) 2013 Monotype Imaging Inc. All rights reserved.          */
/*                                                                         */
/***************************************************************************/

#ifndef _ITC_FS_PORT_H_
#define _ITC_FS_PORT_H_

#if defined PORT_arm920
#include "../port/arm920/fs_port.h"
#elif defined PORT_iOS
#include "../port/iOS/fs_port.h"
#elif defined PORT_linux
#include "../port/linux/fs_port.h"
#elif defined PORT_linux64
#include "../port/linux64/fs_port.h"
#elif defined PORT_sunOS
#include "../port/sunOS/fs_port.h"
#elif defined PORT_sunOS64
#include "../port/sunOS64/fs_port.h"
#elif defined PORT_symbian
#include "../port/symbian/fs_port.h"
#elif defined WIN32CE
#include "../port/win32_WCE/fs_port.h"
#elif defined WIN32
#include "../port/win32/fs_port.h"
#else
#error "PLATFORM not defined"
#endif

#include "idrv_fio.h"

#undef SYS_FOPEN
#undef SYS_FCLOSE
#undef SYS_FREAD
#undef SYS_FSEEK

#define SYS_FOPEN(a,b) idrv_fopen(a,b)
#define SYS_FCLOSE(a) idrv_fclose(a)
#define SYS_FREAD(a,b,c,d) idrv_fread(a,b,c,d)
#define SYS_FSEEK(a,b,c) idrv_fseek(a,b,c)

#endif /* _ITC_FS_PORT_H_ */
